@echo off
REM Copyright (c) 2008-2015, Pervasync LLC. All rights reserved.
@setlocal enableextensions
@cd /d "%~dp0"
if exist pvc.bat goto start
echo Error!! This batch file can only be executed in its own folder.
goto error

:start
if "%1"=="" goto gui
if "%1"=="sys_tray" goto gui

set SYNC_DIRECTION=
if "%1"=="sync" set SYNC_DIRECTION=TWO_WAY
if "%1"=="auto_sync" set SYNC_DIRECTION=AUTO_SYNC
if "%1"=="refresh" set SYNC_DIRECTION=REFRESH_ONLY
if "%1"=="checkin" set SYNC_DIRECTION=CHECK_IN_ONLY
if "%1"=="ls_net_con" set SYNC_DIRECTION=LS_NET_CON
if not "%SYNC_DIRECTION%"=="" goto sync
goto usage

:gui
start javaw -Xmx512m -classpath "../classes;..\lib\*"  pervasync.client.gui.SyncClient %1
if ERRORLEVEL 1 goto error
goto done

:sync
set PASSWORD=
if not "%2"=="" set PASSWORD=%2
java -Xmx512m -classpath "../classes;..\lib\*" pervasync.client.SyncAgent %SYNC_DIRECTION% %2 %3 %4 %5 %6 %7 %8 %9
if ERRORLEVEL 1 goto error
goto success

:usage
echo. 
echo Usage
echo -----
echo pvc.bat [{sync^|refresh^|checkin^|auto_sync^|sys_tray^|ls_net_con} [^<options^>]]
echo.
echo     Use this command to launch the Pervasync Client Configuration and Sync Utility.
echo     If no arguments are specified, i.e.
echo.
echo     pvc.bat
echo.
echo     the sync client GUI will be launched.  
echo.    
echo     If "sys_tray" is specified as an argument, i.e.
echo.
echo     pvc.bat sys_tray
echo.
echo     the sync client GUI will be launched in system tray (minimized). 
echo.
echo     Otherwise, it will run in non-GUI mode. 
echo.    Use the "sync" sub-command to do two-way sync, e.g.
echo.
echo     pvc.bat sync
echo.
echo     Use "refresh" and "checkin" to do one-way sync. 
echo.
echo     You use "auto_sync" option to start the job scheduler for running sync jobs 
echo     at pre-arranged times. Use the "Schedule" tab of the GUI to update job schedules.
echo.
echo     You use "ls_net_con" option to list the network connection info of the device.
echo     The info is needed to setup sync-based-on-network-characterics on server.
echo.
echo     You can supply the following options following sync/refresh/checkin commands.
echo     -password ^<password^>
echo     Stored password will be used if this option is absent.
echo     -data_only
echo     With this option, only schemas will be synced.  Folders will not be synced.
echo     -file_only
echo     With this option, only folders will be synced. Schemas will not be synced.
echo     -sync_schemas  ^<sync_schemas^>
echo     Select sync schemas to be included in the sync. 
echo     -sync_folders  ^<sync_folders^>
echo     Select sync folders to be included in the sync. 
echo     Use quotes and comma to supply multiple schemas/folders. For example
echo     pvc.bat sync -sync_schemas "schema1,schema2"
echo.
echo     Note that the JDBC jar file (for Oracle) or Java connector jar file
echo     (for MySQL) has to be available in folder ../lib to run this script.
echo.
if "%1"=="-h" goto done
if "%1"=="/h" goto done
if "%1"=="--help" goto done

:error
set BATCH_ERROR=1
if not "%1"=="" echo Shell script completed with error.
goto done

:success
set BATCH_ERROR=0
echo Shell script completed successfully.

:done
rem -- We're done!