#!/bin/sh
# Copyright (c) 2008-2015, Pervasync LLC. All rights reserved.

usage(){
    echo 	
    echo Usage
    echo -----
    echo pvc.sh {sync\|refresh\|checkin\|auto_sync\|sys_tray\|ls_net_con} [\<options\>]
    echo
    echo "    "Use this command to launch the Pervasync client Configuration Utility.
    echo "    "If no arguments are specified, i.e.
    echo
    echo "    "./pvc.sh
    echo
    echo "    "the sync client configuration GUI will be launched. 
    echo "    "If \"sys_tray\" is specified as an argument, i.e.
    echo
    echo "    "./pvc.sh sys_tray
    echo
    echo "    "the sync client GUI will be launched in system tray \(minimized\). 
    echo "    "Otherwise, it will run in non-GUI mode. 
    echo "    "Use the \"sync\" sub-command to do two-way sync, e.g.
    echo
    echo "    "./pvc.sh sync
    echo
    echo "    "Use \"refresh\" and \"checkin\" to do one-way sync. 
    echo
    echo "    "You use \"auto_sync\" option to start the job scheduler for running sync jobs
    echo "    "at pre-arranged times. Use the "Schedule" tab of the GUI to update job schedules.
    echo
    echo "    "You use \"ls_net_con\" option to list the network connection info of the device.
    echo "    "The info is needed to setup sync-based-on-network-characterics on server.
    echo
    echo "    "You can supply the following options following sync/refresh/checkin commands.
    echo "    "-password \<password\>
    echo "    "Stored password will be used if it is absent.
    echo "    "-data_only
    echo "    "With this option, only schemas will be synced. Folders will not be synced.
    echo "    "-file_only
    echo "    "With this option, only folders will be synced. Schemas will not be synced.
    echo "    "-sync_schemas  \<sync_schemas\>
    echo "    "Select sync schemas to be included in the sync. 
    echo "    "-sync_folders  \<sync_folders\>
    echo "    "Select sync folders to be included in the sync. 
    echo "    "Use quotes and comma to supply multiple schemas/folders. For example
    echo "    "./pvc.sh sync -sync_schemas \"schema1,schema2\"
    echo
    echo "    "Note that the JDBC jar file \(for Oracle\) or Java connector jar file
    echo "    "\(for MySQL\) has to be available in folder ../lib to run this script.
    if [ "$1" = "-h" ]; then exit 0; fi
    if [ "$1" = "--help" ]; then exit 0; fi
    exit 1
}

if [ ! -f pvc.sh ]; then
    echo "Error!! This script can only be executed in its own folder."
    exit 1
fi

if [ -z "$1" -o "$1" = "sys_tray" ]; then
    java -Xmx512m -classpath "../classes:$(echo ../lib/*.jar | tr ' ' ':')"  pervasync.client.gui.SyncClient $1 >/dev/null &
    if [ $? != 0 ] ; then exit 1; else exit 0; fi
else 
    SYNC_DIRECTION=
    if [ "$1" = "auto_sync" ]; then SYNC_DIRECTION=AUTO_SYNC; fi
    if [ "$1" = "sync" ]; then SYNC_DIRECTION=TWO_WAY; fi
    if [ "$1" = "refresh" ]; then SYNC_DIRECTION=REFRESH_ONLY; fi
    if [ "$1" = "checkin" ]; then SYNC_DIRECTION=CHECK_IN_ONLY; fi
    if [ "$1" = "ls_net_con" ]; then SYNC_DIRECTION=LS_NET_CON; fi
    if [ -z $SYNC_DIRECTION ]; then usage; fi
    PASSWORD=""
    if [ -n "$2" ]; then PASSWORD="$2"; fi

    java -Xmx512m -classpath "../classes:$(echo ../lib/*.jar | tr ' ' ':')" pervasync.client.SyncAgent $SYNC_DIRECTION $2 $3 $4 $5 $6 $7 $8 $9
    if [ $? != 0 ] ; then exit 1; fi
fi

echo "Shell script completed successfully."

