#!/bin/sh

error(){
    echo "Shell script completed with error."
    exit 1
}

if [ ! -f client_app_oracle.sh ]; then
    echo "Error!! This script can only be executed in its own folder."
    error
else 
    myclasspath=".:../../classes:$(echo ../../lib/*.jar | tr ' ' ':')"
    if [ $# = 1 ] && [ "$1" = "compile" ] ; then
        javac -classpath $myclasspath -d . ClientAppOracle.java
        if [ $? != 0 ] ; then error; fi
    elif [ $# = 1 ] && ( [ "$1" = "sync" ]\
        || [ "$1" = "insert" ] || [ "$1" = "delete" ] \
        || [ "$1" = "update" ] ); then
        java -classpath $myclasspath  ClientAppOracle $1
        if [ $? != 0 ] ; then error; fi
    else
        echo " 	Usage"
        echo " 	-----"
        echo "	client_app_oracle.sh {compile | sync "
        echo "	    | insert | delete | update}"
        echo ""
        error
    fi
fi

echo "Shell script completed successfully."

