#!/bin/sh

error(){
    echo "Shell script completed with error."
    exit 1
}

if [ ! -f client_app_postgresql.sh ]; then
    echo "Error!! This script can only be executed in its own folder."
    error
else 
    myclasspath=".:../../classes:$(echo ../../lib/*.jar | tr ' ' ':')"
    if [ $# = 1 ] && [ "$1" = "compile" ] ; then
        javac -classpath $myclasspath -d . ClientAppPostgresql.java
        if [ $? != 0 ] ; then error; fi
    elif [ $# = 1 ] && ( [ "$1" = "sync" ] \
        || [ "$1" = "insert" ] || [ "$1" = "delete" ] \
        || [ "$1" = "update" ] || [ "$1" = "add_sync_table" ]); then
        java -classpath $myclasspath  ClientAppPostgresql $1
        if [ $? != 0 ] ; then error; fi
    else
        echo " 	Usage"
        echo " 	-----"
        echo "	client_app_postgresql.sh {compile | sync "
        echo "	    | insert | delete | update | add_sync_table}"
        echo ""
        error
    fi
fi

echo "Shell script completed successfully."

